/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.network.commands.parser;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Stream;
import moze_intel.projecte.utils.LazyTagLookup;
import moze_intel.projecte.utils.text.PELang;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.item.ItemParser;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NSSItemParser {
    private static final DynamicCommandExceptionType UNKNOWN_TAG = new DynamicCommandExceptionType(xva$0 -> PELang.UNKNOWN_TAG.translate(xva$0));
    private static final Function<SuggestionsBuilder, CompletableFuture<Suggestions>> DEFAULT_SUGGESTIONS_BUILDER = SuggestionsBuilder::buildFuture;
    private final StringReader reader;
    @Nullable
    private Item item;
    @Nullable
    private CompoundTag nbt;
    @Nullable
    private TagKey<Item> tag;
    private int readerCursor;
    private Function<SuggestionsBuilder, CompletableFuture<Suggestions>> suggestionsBuilder = DEFAULT_SUGGESTIONS_BUILDER;

    public NSSItemParser(StringReader readerIn) {
        this.reader = readerIn;
    }

    public NSSItemResult getResult() throws CommandSyntaxException {
        if (this.item != null) {
            return new NSSItemResult(this);
        }
        if (this.tag == null) {
            throw UNKNOWN_TAG.create((Object)"");
        }
        if (!LazyTagLookup.tagManager(ForgeRegistries.ITEMS).isKnownTagName(this.tag)) {
            throw UNKNOWN_TAG.create((Object)this.tag.f_203868_().toString());
        }
        return new NSSItemResult(this);
    }

    public NSSItemParser parse() throws CommandSyntaxException {
        this.suggestionsBuilder = this::suggestTagOrItem;
        if (this.reader.canRead() && this.reader.peek() == '#') {
            this.suggestionsBuilder = this::suggestTag;
            this.reader.expect('#');
            this.readerCursor = this.reader.getCursor();
            this.tag = TagKey.m_203882_((ResourceKey)Registry.f_122904_, (ResourceLocation)ResourceLocation.m_135818_((StringReader)this.reader));
        } else {
            int i = this.reader.getCursor();
            ResourceLocation itemId = ResourceLocation.m_135818_((StringReader)this.reader);
            this.item = (Item)ForgeRegistries.ITEMS.getValue(itemId);
            if (this.item == null) {
                this.reader.setCursor(i);
                throw ItemParser.f_120992_.createWithContext((ImmutableStringReader)this.reader, (Object)itemId);
            }
            this.suggestionsBuilder = this::suggestItem;
            if (this.reader.canRead() && this.reader.peek() == '{') {
                this.suggestionsBuilder = DEFAULT_SUGGESTIONS_BUILDER;
                this.nbt = new TagParser(this.reader).m_129373_();
            }
        }
        return this;
    }

    private CompletableFuture<Suggestions> suggestItem(SuggestionsBuilder builder) {
        if (builder.getRemaining().isEmpty()) {
            builder.suggest(String.valueOf('{'));
        }
        return builder.buildFuture();
    }

    private CompletableFuture<Suggestions> suggestTag(SuggestionsBuilder builder) {
        return SharedSuggestionProvider.m_82957_(this.getTagNames(), (SuggestionsBuilder)builder.createOffset(this.readerCursor));
    }

    private CompletableFuture<Suggestions> suggestTagOrItem(SuggestionsBuilder builder) {
        SharedSuggestionProvider.m_205106_(this.getTagNames(), (SuggestionsBuilder)builder, (String)String.valueOf('#'));
        return SharedSuggestionProvider.m_82926_((Iterable)ForgeRegistries.ITEMS.getKeys(), (SuggestionsBuilder)builder);
    }

    private Stream<ResourceLocation> getTagNames() {
        return LazyTagLookup.tagManager(ForgeRegistries.ITEMS).getTagNames().map(TagKey::f_203868_);
    }

    public CompletableFuture<Suggestions> fillSuggestions(SuggestionsBuilder builder) {
        return this.suggestionsBuilder.apply(builder.createOffset(this.reader.getCursor()));
    }

    public static class NSSItemResult {
        @Nullable
        private final Item item;
        @Nullable
        private final CompoundTag nbt;
        private ResourceLocation tagId = new ResourceLocation("");

        public NSSItemResult(NSSItemParser parser) {
            this.item = parser.item;
            this.nbt = parser.nbt;
            if (parser.tag != null) {
                this.tagId = parser.tag.f_203868_();
            }
        }

        public NSSItemResult(@NotNull ItemStack stack) {
            this.item = stack.m_41720_();
            this.nbt = stack.m_41783_();
        }

        public String getStringRepresentation() {
            if (this.item == null) {
                return "#" + this.tagId;
            }
            if (this.nbt == null) {
                return this.item.getRegistryName().toString();
            }
            return this.item.getRegistryName().toString() + this.nbt;
        }
    }
}

